/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.recaps;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.ui.asistentes.AsistenteBase;
import ec.gob.sri.dimm.ats.modelo.obj.Comprobante;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.recap.Recap;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.recaps.DatosConsumo;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.recaps.InformacionEstablecimiento;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.recaps.PaginaPagoLocalExterior;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;

public class AsistenteNuevaRecap
extends AsistenteBase
implements INewWizard {
    private InformacionEstablecimiento paginaEstablecimiento;
    private DatosConsumo datosConsumo;
    private PaginaPagoLocalExterior pagoLocalExterior;
    public static final String ID = "ec.gob.sri.dimm.ats.ui.asistentes.recaps.AsistenteNuevaRecap";
    private final Recap modeloDatos;
    private final Recap copiaValidacion;
    private boolean editando;
    private Periodo periodo;

    public AsistenteNuevaRecap(Recap recap, boolean editando, Periodo periodo) {
        this.modeloDatos = recap;
        this.copiaValidacion = new Recap();
        this.copiaValidacion.setPropietario((ObjetoModelo)((Iva)this.modeloDatos.getPropietario()));
        this.copiaValidacion.getComprobanteRetencion().inicializar();
        this.copiaValidacion.getComprobanteRetencion().setObligatorio(false);
        this.editando = editando;
        this.periodo = periodo;
    }

    public void addPages() {
        this.paginaEstablecimiento = new InformacionEstablecimiento(this.editando, this.periodo);
        this.paginaEstablecimiento.setModeloDatos(this.modeloDatos);
        this.paginaEstablecimiento.inicializarModeloValores();
        this.datosConsumo = new DatosConsumo(this.editando, this.periodo);
        this.datosConsumo.setModeloDatos(this.modeloDatos.getConsumo());
        this.datosConsumo.inicializarModeloValores();
        this.pagoLocalExterior = new PaginaPagoLocalExterior(this.editando, this.periodo);
        this.pagoLocalExterior.setModeloDatos(this.copiaValidacion);
        this.pagoLocalExterior.inicializarModeloValores();
        this.addPage((IWizardPage)this.paginaEstablecimiento);
        this.addPage((IWizardPage)this.datosConsumo);
        this.addPage((IWizardPage)this.pagoLocalExterior);
    }

    public boolean performFinish() {
        this.modeloDatos.getPagoLocalExterior().actualizarInformacion(this.copiaValidacion.getPagoLocalExterior());
        this.modeloDatos.getComprobanteRetencion().actualizarInformacion((Comprobante)this.copiaValidacion.getComprobanteRetencion());
        return true;
    }
}

